% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{random.estimate}
\alias{random.estimate}
\title{Generate random numbers for an estimate.}
\usage{
\method{random}{estimate}(rho, n, method = "calculate", relativeTolerance = 0.05, ...)
}
\arguments{
\item{rho}{\code{estimate}: multivariate distribution to be randomly sampled.}

\item{n}{\code{integer}:Number of observations to be generated.}

\item{method}{\code{character}: Particular method to be used for random number generation.}

\item{relativeTolerance}{\code{numeric}: the relative tolerance level of deviation of the
generated confidence interval from the specified interval. If this deviation is greater than
\code{relativeTolerance} a warning is given.}

\item{...}{Optional arguments to be passed to the particular random number
generating function.}
}
\description{
This function generates random numbers for general multivariate
distributions that are defined as an \code{\link{estimate}}.
}
\details{
\subsection{Generation of uncorrelated components}{
		Implementation: \code{\link{random.estimate1d}}

	}
	\subsection{Generation of correlated components}{
		Implementation: \code{\link{rmvnorm90ci_exact}}
	}
}
\examples{
variable=c("revenue","costs")
distribution=c("norm","norm")
 lower=c(10000,  5000)
 upper=c(100000, 50000)
 estimateObject<-as.estimate(variable, distribution, lower, upper)
 x<-random(rho=estimateObject, n=10000)
 apply(X=x, MARGIN=2, FUN=quantile, probs=c(0.05, 0.95))
 cor(x)
 colnames(x)
 summary(x)
 hist(x[,"revenue"])
 hist(x[,"costs"])
 
 # Create an estimate with median and method information:
 estimateObject<-estimate(         c("posnorm", "lnorm"),
                                   c(        4,       4),
                                   c(       50,      10),
                          variable=c("revenue", "costs"),
                          median = c(   "mean",      NA),
                          method = c(    "fit",      ""))
 # Sample random values for this estimate:
 x<-random(rho=estimateObject, n=10000)
 # Check the results 
 apply(X=x, MARGIN=2, FUN=quantile, probs=c(0.05, 0.95))
 summary(x)
 hist(x[,"revenue"], breaks=100)
 hist(x[,"costs"], breaks=100)
 
}
\seealso{
\code{\link{estimate}}, \code{\link{random.estimate1d}}, \code{\link{random}}
}
