% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate_write_csv}
\alias{estimate_write_csv}
\title{Write an Estimate to CSV - File.}
\usage{
estimate_write_csv(
  estimate,
  fileName,
  varNamesAsColumn = TRUE,
  quote = FALSE,
  ...
)
}
\arguments{
\item{estimate}{\code{estimate}: Estimate object to write to file.}

\item{fileName}{\code{character}: File name for the output of the marginal information of the 
estimate. It must end with \code{.csv}.}

\item{varNamesAsColumn}{\code{logical}: If \code{TRUE} the variable names will be written as a
separate column, otherwise as row names.}

\item{quote}{a \code{logical} value (TRUE or FALSE) or a numeric vector. If
TRUE, any character or factor columns will be surrounded by double quotes.
If a numeric vector, its elements are taken as the indices of columns to
quote. In both cases, row and column names are quoted if they are written.
If FALSE, nothing is quoted. Parameter is passed on to \code{\link{write.table}}.}

\item{...}{Further parameters to be passed to \code{\link[utils]{write.table}}.}
}
\description{
This function writes an \code{\link{estimate}} to the specified csv file(s).
}
\details{
The marginal information of the \code{estimate} is written to file \code{fileName=<marginal-filename>.csv}. If 
  the estimate contains correlated variables, the correlation matrix is written to the separate
  file \code{<marginal-filename>_cor.csv}.
}
\seealso{
\code{\link{estimate_read_csv}}, \code{\link{estimate}}, \code{\link[utils]{write.table}}
}
