% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{debugme}
\alias{debugme}
\alias{debugme-package}
\title{Debug R Packages}
\usage{
debugme(env = topenv(parent.frame()), pkg = environmentName(env))
}
\arguments{
\item{env}{Environment to instument debugging in. Defaults to the
package environment of the calling package.}

\item{pkg}{Name of the calling package. The default should be fine
for almost all cases.}
}
\description{
Specify debug messages as special string constants, and control
debugging of packages via environment variables.
}
\details{
To add debugging to your package, you need to
\enumerate{
\item Import the \code{debugme} package.
\item Define an \code{.onLoad} function in your package, that calls \code{debugme}.
An example:\preformatted{.onLoad <- function(libname, pkgname) { debugme::debugme() }
}
}

By default debugging is off. To turn on debugging, set the \code{DEBUGME}
environment variable to the names of the packages you want to debug.
Package names can be separated by commas.

Note that \code{debugme} checks for environment variables when it is starting
up. Environment variables set after the package is loaded do not have
any effect.

Example \code{debugme} entries:\preformatted{"!DEBUG Start Shiny app"
}
}
\section{Dynamic debug messsages}{


It is often desired that the debug messages contain values of R
expressions evaluated at runtime. For example, when starting a Shiny
app, it is useful to also print out the path to the app. Similarly,
when debugging an HTTP response, it is desired to log the HTTP status
code.

\code{debugme} allows embedding R code into the debug messages, within
backticks. The code will be evaluated at runtime. Here are some
examples:\preformatted{"!DEBUG Start Shiny app at `path`"
"!DEBUG Got HTTP response `httr::status_code(reponse)`"
}

Note that parsing the debug strings for code is not very sophisticated
currently, and you cannot embed backticks into the code itself.
}

\section{Log levels}{

To organize the log messages into log levels, you can start the
\code{!DEBUG} token with multiple \code{!} characters. You can then select the
desired level of logging via \code{!} characters before the package name
in the \code{DEBUGME} environment variable. E.g. \code{DEBUGME=!!mypackage} means
that only debug messages with two or less \code{!} marks will be printed.
}

\section{Debug stack}{

By default \code{debugme} prints the \emph{debug stack} at the beginning of
the debug messages. The debug stack contains the functions in the call
stack that have (and emit) debug messages. To suppress printing the call
stack set the \code{DEBUGME_SHOW_STACK} environment variable to \code{no}.
}

\section{Redirecting the output}{


If the \code{DEBUGME_OUTPUT_FILE} environment variable is set to
a filename, then the output is written there instead of the standard
output stream of the R process.

If \code{DEBUGME_OUTPUT_FILE} is not set, but \code{DEBUGME_OUTPUT_DIR} is, then
a log file is created there, and the name of the file will contain
the process id. This is is useful for logging from several parallel R
processes.
}

