% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mddsPLS.R
\name{predict.mddsPLS}
\alias{predict.mddsPLS}
\title{The predict function of a mdd-sPLS model}
\usage{
\method{predict}{mddsPLS}(object, newdata, ...)
}
\arguments{
\item{object}{A mdd-sPLS object, output from the mddsPLS function.}

\item{newdata}{A data-set where individuals are described by the same as for mod_0}

\item{...}{Other plotting parameters to affect the plot.}
}
\value{
A matrix of estimated \emph{Y_test} values.
}
\description{
The predict function of a mdd-sPLS model
}
\examples{
data("liver.toxicity")
X <- scale(liver.toxicity$gene)
Y <- scale(liver.toxicity$clinic)
mod_0 <- mddsPLS(X,Y)
Y_test <- predict(mod_0,X)
}
