% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_wrappers.R
\name{mdl_glmnet}
\alias{mdl_glmnet}
\title{Wrapper for \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.}
\usage{
mdl_glmnet(y, X, cv = TRUE, ...)
}
\arguments{
\item{y}{The outcome variable.}

\item{X}{The (sparse) feature matrix.}

\item{cv}{Boolean to indicate use of lasso with cross-validated penalty.}

\item{...}{Additional arguments passed to \code{glmnet}. See
\code{\link[glmnet:glmnet]{glmnet::glmnet()}} and \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}} for a complete list of
arguments.}
}
\value{
\code{mdl_glmnet} returns an object of S3 class \code{mdl_glmnet} as
a simple mask of the return object of \code{\link[glmnet:glmnet]{glmnet::glmnet()}} or
\code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}.
}
\description{
Simple wrapper for \code{\link[glmnet:glmnet]{glmnet::glmnet()}} and \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}.
}
\examples{
glmnet_fit <- mdl_glmnet(rnorm(100), matrix(rnorm(1000), 100, 10))
class(glmnet_fit)
}
\references{
Friedman J, Hastie T, Tibshirani R (2010). "Regularization Paths for
Generalized Linear Models via Coordinate Descent." Journal of Statistical
Software, 33(1), 1–22.

Simon N, Friedman J, Hastie T, Tibshirani R (2011). "Regularization Paths for
Cox's Proportional Hazards Model via Coordinate Descent." Journal of
Statistical Software, 39(5), 1–13.
}
\seealso{
\code{\link[glmnet:glmnet]{glmnet::glmnet()}},\code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}

Other ml_wrapper: 
\code{\link{mdl_ranger}()},
\code{\link{mdl_xgboost}()},
\code{\link{ols}()}
}
\concept{ml_wrapper}
