\name{m0.st}
\alias{m0.bdn}
\alias{m0.nhcw}
\alias{m0.st}
\alias{m0.storey}
\title{Estimate the Number of True Null Hypotheses}
\usage{
  m0.st(p, lambda = seq(0, 0.95, 0.05))

  m0.nhcw(p, bins = 20)

  m0.bdn(obj, bins = 20)
}
\arguments{
  \item{p}{a vector of pvalues.}

  \item{lambda}{points chosen for fitting spline which can
  be considered as tuning parameters in estimating m0.
  These points must be in [0,1] and a defualt value
  seq(0,0.95,0.05) is used. For more information, please
  see Storey and Tibshirani (2003).}

  \item{bins}{number of bins to be used in the
  histogram-based methods. A default value 20 is used,
  which is recommended in Netlleton et al. (2006) and
  Bancroft, Du and Nettleton (2013).}

  \item{obj}{an object of class "spt" (returned by
  \code{spt} or wrapper function generated by
  \code{cxxwrapper}).}
}
\value{
  the estimate of \code{m0}.
}
\description{
  Estimating the number of true null hypotheses (\code{m0})
  is critical for estiamting the false discover rate (FDR).
  The function \code{m0.st} estimates \code{m0} using the
  method proposed in Storey and Tibshirani (2003). The
  function \code{m0.nhcw} estimates \code{m0} using the
  method proposed in Nettleton et al. (2006). The function
  \code{m0.bdn} estimates \code{m0} using the method
  proposed in Bancroft, Du and Nettleton (2013).
}
\examples{
#simulate 1000 p-vlaues from a mixture beta and uniform distribution.
p = rbunif(1000, alpha=1, beta=29, gamma=0.7)
#estimate m0 using the method in Story and Tibshirani (2003).
m0.st(p)
#estimate m0 using the method in Nettleton et al. (2006)
m0.nhcw(p)
# ---------- a real example in Bancroft, Du and Nettleton (2013) --------------
# read in C++ source code
tsf_code = read_code("test_statistics.cpp")
# genrate function for sequential permutation test
# for no location difference between two samples
if(!exists("cxxspt.mean")){
    cxxwrapper(tsf_code, "abs_mean_diff0", "abs_mean_diff", c("n1", "", "int")) -> cxxspt.mean
}
# download data
if(!file.exists('spt_data.rda')){
    download.file('http://dclong.github.io/media/spt/spt_data.rda', 'spt_data.rda')
}
load('spt_data.rda')
cxxspt.mean(leukemia, 10, 1000, n1=5) -> cxxspt.out
#estimate m0 using the method in Bancroft, Du and Nettleton (2013).
m0.bdn(cxxspt.out, 20)
}
\references{
  Storey, J. D., & Tibshirani, R. (2003). Statistical
  significance for genomewide studies. Proceedings of the
  National Academy of Sciences, 100(16), 9440-9445.

  Nettleton, D., Hwang, J. G., Caldo, R. A., & Wise, R. P.
  (2006). Estimating the number of true null hypotheses
  from a histogram of p values. Journal of agricultural,
  biological, and environmental statistics, 11(3), 337-356.

  Bancroft, T., Du, C. and Nettleton, D. (2013), Estimation
  of False Discovery Rate Using Sequential Permutation
  p-Values. Biometrics, 69: 1-7. doi:
  10.1111/j.1541-0420.2012.01825.x
}
\seealso{
  \code{\link{fdr}} for estimating false discover rate and
  calculating qvalues.
}

