% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-keys.R
\name{check_keys}
\alias{check_keys}
\title{Check that a given set of keys are all present in an annotations dictionary}
\usage{
check_keys(
  x,
  annotations,
  whitelist_keys = NULL,
  success_msg = "All annotation keys are valid",
  fail_msg = "Some annotation keys are invalid",
  return_valid = FALSE,
  syn
)
}
\arguments{
\item{x}{A data frame of annotation data}

\item{annotations}{A data frame of annotations to check against}

\item{whitelist_keys}{A character vector of annotation keys to whitelist. If
provided, all values for the given keys will be treated as valid.}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}

\item{return_valid}{Should the function return valid values? Defaults to
\code{FALSE} (i.e. the function will return invalid values).}

\item{syn}{Synapse client object}
}
\value{
A condition object indicating whether keys match the given annotation
dictionary. Erroneous keys are included as data within the object.
}
\description{
Check that a given set of keys are all present in an annotations dictionary
}
\examples{
annots <- data.frame(
  key = c("fileFormat", "fileFormat"),
  value = c("txt", "csv"),
  columnType = c("STRING", "STRING"),
  stringsAsFactors = FALSE
)
check_keys("fileFormat", annots)
check_keys("x", annots)
}
