% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcSupraBetter.r
\name{dcSupraBetter}
\alias{dcSupraBetter}
\title{Function to find supra-domains with better scores than their individual domains}
\usage{
dcSupraBetter(input.file, output.file = NULL, verbose = T)
}
\arguments{
\item{input.file}{an input file used to build the object. This input
file contains original annotations between domains/features and
ontology terms, along with the hypergeometric scores (hscore) in
support for their annotations. For example, a file containing original
annotations between SCOP domain architectures and GO terms can be found
in
\url{http://dcgor.r-forge.r-project.org/data/Feature/Feature2GO.sf.txt}.
As seen in this example, the input file must contain the header (in the
first row) and three columns: 1st column for 'Feature_id' (here SCOP
domain architectures), 2nd column for 'Term_id' (GO terms), and 3rd
column for 'Score' (hscore)}

\item{output.file}{an output file containing results. If not NULL, a
tab-delimited text file will be also written out, with 1st column
'Feature_id' for features/domains, 2nd column 'Term_id' for ontology
terms, 3rd column 'Score' for hypergeometric scores (indicative of
strength for feature-term associations). Otherwise, there is no output
file (by default)}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a data frame containing three columns: 1st column 'Feature_id' for
features, 2nd 'Term_id' for terms, and 3rd 'Score' for the
hypergeometric score indicative of strength of associations beteen
features and terms
}
\description{
\code{dcSupraBetter} is supposed to find supra-domains with better
scores than their individual domains.
}
\note{
When 'output.file' is specified, a tab-delimited text file is output,
with the column names: 1st column 'Feature_id' for features, 2nd
'Term_id' for terms, and 3rd 'Score' for the hypergeometric score
indicative of strength of associations beteen features and terms
}
\examples{
\dontrun{
input.file <-
"http://dcgor.r-forge.r-project.org/data/Feature/Feature2GO.sf.txt"
res <- dcSupraBetter(input.file)
res[1:10,]
}
}
\seealso{
\code{\link{dcList2Matrix}}
}

