% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcList2Matrix.r
\name{dcList2Matrix}
\alias{dcList2Matrix}
\title{Function to convert a list into a matrix containing three columns}
\usage{
dcList2Matrix(x, verbose = T)
}
\arguments{
\item{x}{a list, its each component must be a named vector}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a matrix containing three columns: 1st for the input list names (if
exist, otherises an increasing integer), 2nd for the vector names of
each list component, and 3rd for the vector values of each list
component
}
\description{
\code{dcList2Matrix} is supposed to convert a list into a matrix
containing three columns
}
\note{
none
}
\examples{
\dontrun{
# load an object 'HIS'
Feature2GOMF.sf <- dcRDataLoader(RData='Feature2GOMF.sf')
# get a list
x <- Feature2GOMF.sf$hscore
# convert the list into a matrix
res <- dcList2Matrix(x)
dim(res)
res[1:10,]
}
}
\seealso{
\code{\link{dcAlgoPropagate}}
}

