% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{dbxDelete}
\alias{dbxDelete}
\title{Delete records}
\usage{
dbxDelete(conn, table, where = NULL, batch_size = NULL)
}
\arguments{
\item{conn}{A DBIConnection object}

\item{table}{The table name to delete records from}

\item{where}{A data frame of records to delete}

\item{batch_size}{The number of records to delete in a single statement (defaults to all)}
}
\description{
Delete records
}
\examples{
db <- dbxConnect(adapter="sqlite", dbname=":memory:")
table <- "forecasts"
DBI::dbCreateTable(db, table, data.frame(id=1:3, temperature=20:22))

# Delete specific records
bad_records <- data.frame(id=c(1, 2))
dbxDelete(db, table, where=bad_records)

# Delete all records
dbxDelete(db, table)
}
