% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\name{summary.dbcsp}
\alias{summary.dbcsp}
\title{Summary function implemented by dbcsp class}
\usage{
\method{summary}{dbcsp}(object, ...)
}
\arguments{
\item{object}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{...}{optional arguments inherited from the generic \code{\link{summary}} method.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides a summary of the dbcsp object and information about the performed process.
}
\details{
It prints the following information:
\itemize{
\item Length and shape of the list of matrices of each class.
\item The number of vectors (dimensions) used in the CSP projection.
\item Distance used when performing the Common Spatial Patterns algorithm.
\item If the training process has already been performed, the obtained training accuracy value.
}
}
\examples{
# Read data from 2 classes
x <- AR.data$come[1:30]
y <- AR.data$five[1:30]
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
summary(mydbcsp)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link{train}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
