% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NA_check.R
\name{NA_check}
\alias{NA_check}
\title{Missing Value (NA) Check}
\usage{
NA_check(DD.dict, DS.data, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as the number of NA values observed in the data set.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (the number of NA values in the data set and information on if NA is a properly encoded value).
}
\description{
Checks for NA values in the data set; if NA values are present, also performs check for NA value=meaning.
}
\examples{
# Example 1: Fail check
data(ExampleK)
NA_check(DD.dict.K, DS.data.K)
print(NA_check(DD.dict.K, DS.data.K, verbose=FALSE))

# Example 2: Pass check
data(ExampleA)
NA_check(DD.dict.A, DS.data.A)
print(NA_check(DD.dict.A, DS.data.A, verbose=FALSE))
}
