% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_group.R
\name{data_group}
\alias{data_group}
\alias{data_ungroup}
\title{Create a grouped data frame}
\usage{
data_group(
  x,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  verbose = TRUE,
  ...
)

data_ungroup(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{A data frame}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")},
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-Sepal.Width:Petal.Length}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{verbose}{Toggle warnings.}

\item{...}{Arguments passed down to other functions. Mostly not used yet.}
}
\value{
A grouped data frame, i.e. a data frame with additional information
about the grouping structure saved as attributes.
}
\description{
This function is comparable to \code{dplyr::group_by()}, but just
following the \strong{datawizard} function design. \code{data_ungroup()} removes the
grouping information from a grouped data frame.
}
\examples{
data(efc)
if (requireNamespace("poorman")) {
  suppressPackageStartupMessages(library(poorman, quietly = TRUE))

  # total mean
  efc \%>\%
    summarize(mean_hours = mean(c12hour, na.rm = TRUE))

  # mean by educational level
  efc \%>\%
    data_group(c172code) \%>\%
    summarize(mean_hours = mean(c12hour, na.rm = TRUE))
}
}
