% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset.R
\name{create_dataset}
\alias{create_dataset}
\alias{update_dataset}
\title{Create or update a dataset}
\usage{
create_dataset(
  dataverse,
  body,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)

update_dataset(
  dataset,
  body,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{dataverse}{A character string specifying a Dataverse name or an object of class \dQuote{dataverse}.}

\item{body}{A list describing the dataset.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \code{DATAVERSE_SERVER = "dataverse.harvard.edu"} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{...}{Additional arguments passed to an HTTP request function,
such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}. See \code{\link{use_cache}} for details
on how the \emph{R} dataverse package uses disk and session caches to
improve network performance.}

\item{dataset}{A character specifying a persistent identification ID for a dataset,
for example \code{"10.70122/FK2/HXJVJU"}. Alternatively, an object of class
\dQuote{dataverse_dataset} obtained by \code{dataverse_contents()}.}
}
\value{
An object of class \dQuote{dataverse_dataset}.
}
\description{
Create or update dataset within a Dataverse
}
\details{
\code{create_dataset} creates a Dataverse dataset. In Dataverse, a \dQuote{dataset} is the lowest-level structure in which to organize files. For example, a Dataverse dataset might contain the files used to reproduce a published article, including data, analysis code, and related materials. Datasets can be organized into \dQuote{Dataverse} objects, which can be further nested within other Dataverses. For someone creating an archive, this would be the first step to producing said archive (after creating a Dataverse, if one does not already exist). Once files and metadata have been added, the dataset can be published (i.e., made public) using \code{\link{publish_dataset}}.

\code{update_dataset} updates a Dataverse dataset that has already been created using \code{\link{create_dataset}}. This creates a draft version of the dataset or modifies the current draft if one is already in-progress. It does not assign a new version number to the dataset nor does it make it publicly visible (which can be done with \code{\link{publish_dataset}}).
}
\examples{
\dontrun{
meta <- list()
ds <- create_dataset("mydataverse", body = meta)

meta2 <- list()
update_dataset(ds, body = meta2)

# cleanup
delete_dataset(ds)
}
}
\seealso{
\code{\link{get_dataset}}, \code{\link{delete_dataset}}, \code{\link{publish_dataset}}
}
