% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/related_item.R
\name{related_item_identifier}
\alias{related_item_identifier}
\title{Create a related item identifier}
\usage{
related_item_identifier(
  Identifier,
  relatedIdentifierType,
  relationType,
  schemeURI = NA_character_,
  schemeType = NA_character_,
  resourceTypeGeneral = NA_character_
)
}
\arguments{
\item{Identifier}{The Identifier is a unique string that identifies a resource. For software, determine
whether the identifier is for a specific version of a piece of software, (per the
\href{https://force11.org/info/software-citation-principles-published-2016/}{Force11 Software Citation Principles},
or for all versions. Similar to \code{dct:title} in \code{\link{dublincore}}.}

\item{relatedIdentifierType}{See \href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#12a-relatedidentifiertype}{relatedIdentifierType}.}

\item{relationType}{See \href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#12b-relationtype}{relationType}.}

\item{schemeURI}{See \href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#12d-schemeuri}{schemeURI}.}

\item{schemeType}{See \href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#12e-schemetype}{schemeType}.}

\item{resourceTypeGeneral}{The general type of a resource or file.
See \code{\link{resource_type_general}} for allowed values and validation.}
}
\value{
A data.frame
}
\description{
Create a related item identifier
}
\keyword{internal}
