% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolocation.R
\name{geolocation}
\alias{geolocation}
\alias{geolocation<-}
\title{Get/set the Geolocation of the object.}
\usage{
geolocation(x)

geolocation(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{An R object, such as a data.frame, a tibble, or a data.table.}

\item{overwrite}{If the attributes should be overwritten. In case it is set to \code{FALSE},
it gives a message with the current \code{Geolocation} property instead of overwriting it.
Defaults to \code{TRUE} when the attribute is set to \code{value} regardless of previous
setting.}

\item{value}{The  \code{Geolocation} as a character string.}
}
\value{
The \code{Geolocation} attribute as a character of length 1 is added to \code{x}.
}
\description{
Get/set the optional \code{Geolocation} property as an attribute to an
R object.
}
\details{
The \code{Geolocation} is recommended for discovery in DataCite.
Spatial region or named place where the data was gathered
or about which the data is focused.
}
\examples{
iris_dataset <- iris
geolocation(iris_dataset) <- "US"
geolocation(iris_dataset)

geolocation(iris_dataset, overwrite = FALSE) <- "GB"

}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{dataset_source}()},
\code{\link{description}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{size}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
