% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnomalyAssessment.R
\name{GetAnomalyAssessmentPredictionsPreview}
\alias{GetAnomalyAssessmentPredictionsPreview}
\title{Retrieve anomaly assessment predictions preview.}
\usage{
GetAnomalyAssessmentPredictionsPreview(projectId, recordId)
}
\arguments{
\item{projectId}{character. The ID of the project.}

\item{recordId}{character. The ID of the anomaly assessment record.}
}
\value{
The anomaly assessment predictions preview:
\itemize{
\item recordId. character. The ID of the record.
\item projectId. character. The project ID of the record.
\item modelId. character. The model ID of the record.
\item backtest. character. The backtest of the record.
\item source. character. The source of the record.
\item seriesId. character. the series ID of the record.
\item startDate. POSIXct. Timestamp of the first prediction in the subset.
\item endDate. POSIXct. Timestamp of the last prediction in the subset.
\item previewBins. list. A list of PreviewBin objects in the specified date range.
The aggregated predictions for the subset. Bins boundaries may differ from actual start/end
dates because this is an aggregation. Each PreviewBin contains:
\itemize{
\item startDate. POSIXct. Datetime of the start of the bin.
\item endDate. POSIXct. Datetime of the end of the bin.
\item avgPredicted numeric. The average prediction of the model in the bin. NA if
there are no entries in the bin.
\item maxPredicted numeric. The maximum prediction of the model in the bin. NA if
there are no entries in the bin.
\item frequency integer. The number of the rows in the bin.
}
}
}
\description{
Aggregated predictions over time for the corresponding anomaly assessment record.
Intended to find the bins with highest anomaly scores.
}
\examples{
\dontrun{
projectId <- "59a5af20c80891534e3c2bde"
recordId <- "59a5af20c80891534e3c2bdb"
explanations <- GetAnomalyAssessmentPredictionsPreview(projectId, recordId)
}
}
\seealso{
Other Anomaly Assessment functions: 
\code{\link{DeleteAnomalyAssessmentRecord}()},
\code{\link{GetAnomalyAssessmentExplanations}()},
\code{\link{InitializeAnomalyAssessment}()},
\code{\link{ListAnomalyAssessmentRecords}()}
}
\concept{Anomaly Assessment functions}
