% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaitForJobToComplete.R
\name{WaitForJobToComplete}
\alias{WaitForJobToComplete}
\title{Wait for specified job to complete}
\usage{
WaitForJobToComplete(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{integer identifier (returned for example by RequestPrimeModel)}

\item{maxWait}{maximum time to wait (in seconds) for the job to complete}
}
\description{
Wait for specified job to complete
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  blueprints <- ListBlueprints(projectId)
  blueprint <- blueprints[[1]]
  jobId <- RequestNewModel(projectId, blueprint)
  WaitForJobToComplete(projectId, jobId)
}
}
