% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataRobotRequests.R
\name{MakeDataRobotRequest}
\alias{MakeDataRobotRequest}
\title{Make a HTTP request}
\usage{
MakeDataRobotRequest(requestMethod, routeString, addUrl = TRUE,
  returnRawResponse = TRUE, as = "json", simplifyDataFrame = TRUE,
  body = NULL, query = NULL, timeout = DefaultHTTPTimeout,
  encode = NULL, followLocation = TRUE, filename = NULL)
}
\arguments{
\item{requestMethod}{function. A function from httr (e.g., `httr::GET`, `httr::POST`) to use.}

\item{routeString}{character. The path to make the request on.}

\item{addUrl}{logical. Should the endpoint be prepended to the routeString? (Default TRUE).}

\item{returnRawResponse}{logical. Whether to return the raw httr respnose object (as opposed
to postprocessing and returning the content of that object, which is the default.)}

\item{as}{character. What should the resulting data be interpreted as? (default "json").
Use "file" to download as a file (see \code{filename}).}

\item{simplifyDataFrame}{logical. Whether to invoke \code{jsonlite::simplifyDataFrame}.}

\item{body}{list. The body of the request for POST.}

\item{query}{list. The query parameters for GET.}

\item{timeout}{numeric. How many seconds before the request times out?}

\item{encode}{character. What should the body be encoded as for the JSON request?}

\item{followLocation}{logical. Should HTTR follow the location if provided? (Default TRUE).}

\item{filename}{character. The path of the file to download to, if it is a download request.}
}
\description{
Make a HTTP request
}
