% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelRecommendations.R
\name{ListModelRecommendations}
\alias{ListModelRecommendations}
\title{Retrieve information about model recommendedations made by DataRobot for your project.}
\usage{
ListModelRecommendations(project)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}
}
\value{
A list containing information about each recommendation made by DataRobot, containing:
\itemize{
  \item modelId character. The model ID of the recommended model.
  \item projectId character. The project ID of the project the recommendations were made for.
  \item recommendationType character. The type of recommendation being made.
}
}
\description{
DataRobot will help pick out a few models from your project that meet certain criteria,
such as being the most accurate model or being a model that captures a good blend of both
prediction speed and model accuracy.
}
\examples{
\dontrun{
 projectId <- "5984b4d7100d2b31c1166529"
 ListModelRecommendations(projectId)
}
}
