% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_inadmissible_categorical.R
\name{con_inadmissible_categorical}
\alias{con_inadmissible_categorical}
\title{Detects variable levels not specified in metadata}
\usage{
con_inadmissible_categorical(
  resp_vars = NULL,
  study_data,
  meta_data,
  label_col,
  threshold = NULL
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{threshold}{\link{numeric} from=0 to=100. a numerical value ranging
from 0-100. Not yet implemented.}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame summarizing inadmissible categories with the
columns:
\itemize{
\item \code{Variables}: variable name/label
\item \code{OBSERVED_CATEGORIES}: the categories observed in the study data
\item \code{DEFINED_CATEGORIES}: the categories defined in the metadata
\item \code{NON_MATCHING}: the categories observed but not defined
\item \code{NON_MATCHING_N}: the number of observations with categories not defined
\item \code{GRADING}: indicator TRUE/FALSE if inadmissible categorical values were
observed
}
\item \code{ModifiedStudyData}: study data having inadmissible categories removed
\item \code{FlaggedStudyData}: study data having cases with inadmissible categories
flagged
}
}
\description{
For each categorical variable, value lists should be defined in the metadata.
This implementation will examine, if all observed levels in the study data
are valid.
}
\details{
\subsection{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Remove missing codes from the study data (if defined in the metadata)
\item Interpretation of variable specific VALUE_LABELS as supplied in the
metadata.
\item Identification of measurements not corresponding to the expected
categories. Therefore two output data frames are generated:
\itemize{
\item on the level of observation to flag each undefined category, and
\item a summary table for each variable.
}
\item Values not corresponding to defined categories are removed in a data frame
of modified study data
}
}
}
\seealso{
\href{https://dfg-qa.ship-med.uni-greifswald.de/VIN_con_impl_inadmissible_categorical.html}{Online Documentation}
}
