% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_write_data.R
\name{dp_write_data}
\alias{dp_write_data}
\alias{dp_write_data.datapackage}
\alias{dp_write_data.dataresource}
\title{Write  data of resource to file}
\usage{
dp_write_data(x, ..., write_categories = TRUE)

\method{dp_write_data}{datapackage}(
  x,
  resource_name,
  data,
  writer = "guess",
  ...,
  write_categories = TRUE
)

\method{dp_write_data}{dataresource}(
  x,
  data,
  datapackage = dp_get_datapackage(x),
  writer = "guess",
  ...,
  write_categories = TRUE
)
}
\arguments{
\item{x}{the Data Package or Data Resource to which the data is to be written
to.}

\item{...}{additional arguments are passed on to the writer function.}

\item{write_categories}{write both the data set \code{x} itself and any
categories lists of fields in the data set.}

\item{resource_name}{name of the Data Resource in the Data Package to which
the data needs to be written.}

\item{data}{\code{data.frame} with the data to write.}

\item{writer}{the writer to use to write the data. This should be either a
function accepting the Data Package, name of the Data Resource, the data and
the \code{write_categories} argument or the character string \code{"guess"}.}

\item{datapackage}{the Data Package to which the data needs to be written.}
}
\value{
The function doesn't return anything. It is called for it's side effect of
creating files in the directory of the Data Package.
}
\description{
Write  data of resource to file
}
\details{
When \code{writer = "guess"} the function will try to guess which writer to
use based on the \code{format} and \code{mediatype} of the Data Resource.
}
