% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{getDataObject}
\alias{getDataObject}
\alias{getDataObject,D1Client-method}
\title{Download a from the DataONE Federation as a DataObject.}
\usage{
getDataObject(x, identifier, ...)

\S4method{getDataObject}{D1Client}(x, identifier, lazyLoad = FALSE,
  limit = "1MB", quiet = TRUE)
}
\arguments{
\item{x}{A D1Client object.}

\item{identifier}{The identifier of the object to get.}

\item{...}{(not yet used)}

\item{lazyLoad}{A \code{logical} value. If TRUE, then only package member system metadata is downloaded and not data.}

\item{limit}{A \code{character} value specifying maximum package member size to download. Specified with "KB", "MB" or "TB"
for example: "100KB", "10MB", "20GB", "1TB". The default is "1MB".}

\item{quiet}{A \code{'logical'}. If TRUE (the default) then informational messages will not be printed.}
}
\value{
A DataObject or NULL if the object was not found in DataONE
}
\description{
A convenience method to download a data object and its associated SystemMetadata, wrapped
in a DataObject class.
}
\details{
This method performs multiple underlying calls to the DataONE repository network. 
CN.resolve() is called to locate the object on one or more repositories, and then each of these
is accessed until success at downloading the associated SystemMetadata and data bytes, which are 
finally wrapped in a DataObject and returned. Replaces previous getD1Object() method in the version 1
dataone library. The \code{lazyLoad} parameter specifies that only sysmeta metadata is downloaded and
not the data itself. This argument is used together with the \code{limit} parameter, which specifies 
the maximum size of data object that will be downloaded. IF \code{lazyLoad} is FALSE, then \code{limit}
is ignored.
}
\examples{
\dontrun{
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
pid <- "solson.5.1"
obj <- getDataObject(d1c, pid)
data <- getData(obj)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}
