% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{invasivesRCI}
\alias{invasivesRCI}
\title{Contains regeneration microsite data in Robinson Crusoe Island forest}
\format{
Data has the following columns
\describe{
  \item{plot.id}{Plot identification code}
  \item{Gap.type}{Canopy gap classified as invaded=Inv, non invaded= Nat or treated =Treat(considering the estimated cover of invasive plant species)}
  \item{Forest.zone}{Location of the plot (gap, border or forest)}
  \item{Ferns}{Estimated cover of fern species (in 2x2 plots)}
  \item{Moss.liverw}{Estimated cover of mosses and liverworts ( in 2x2 plots)}
  \item{Cwd}{Estimated cover of coarse woody debris > 3 cm diameter ( in 2x2 plots)}
  \item{Litter}{Estimated cover of litter (in 2x2 plots)}
  \item{Ms}{Estimated cover of mineral soil ( in 2x2 plots)}
  \item{Rock}{Estimated cover of rocks (in 2x2 plots)}
  \item{Est.age}{Age category for the canopy gap associated to each plot}
    }
}
\source{
The data are provided courtesy of Prof. Rodrigo Vargas-Gaete at Universidad
 de La Frontera (Temuco, Chile).
}
\usage{
data(invasivesRCI)
}
\description{
These are plot-level measurement (2x2 m) data from the forests in the Robinson Crusoe Island, located
 in the Pacific Ocean, 667 km from mainland Chile. Measurements were collected in transects 
 of 100 to 240 meters in which, 398 squared plots (2x2 m) were set to include canopy gaps, 
 gap borders and closed forest conditions.
}
\references{
Vargas-Gaete R, Salas-Eljatib C, Gärtner SM, Vidal OJ, Bannister JR, Pauchard A. 2018. 
 Invasive plant species thresholds in the forests of Robinson Crusoe Island, Chile. 
 Plant Ecology & Diversity, 11(2), 205-215.
}
\keyword{datasets}
