% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{update_labels}
\alias{update_labels}
\title{Dynamically update labels}
\usage{
update_labels(proxy, label.color = "#000", line.width = 1, font.size = 10,
  font.family = "Verdana", ...)
}
\arguments{
\item{proxy}{a proxy as returned by \code{\link{datamapsProxy}}.}

\item{label.color}{color of label.}

\item{line.width}{with of line.}

\item{font.size}{size of font label.}

\item{font.family}{family of font label.}

\item{...}{any other option.}
}
\description{
Dynamically update labels using Shiny
}
\examples{
\dontrun{
library(shiny)

ui <- fluidPage(
  actionButton(
    "update",
    "update labels"
  ),
  datamapsOutput("map")
)

server <- function(input, output){
  states <- data.frame(st = c("AR", "NY", "CA", "IL", "CO", "MT", "TX"),
                       val = c(10, 5, 3, 8, 6, 7, 2))

  output$map <- renderDatamaps({
    states \%>\%
      datamaps(scope = "usa", default = "lightgray") \%>\%
      add_choropleth(st, val) \%>\% 
      add_labels()
  })

  observeEvent(input$update, {
    datamapsProxy("map") \%>\%
      update_labels(sample(c("blue", "red", "orange", "green", "white"), 1)) # update
  })
}

shinyApp(ui, server)
}

}
