% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_party_avatar.R
\name{download_party_avatar}
\alias{download_party_avatar}
\title{Returns the Avatar(s) (images) for Authorized User(s).}
\usage{
download_party_avatar(
  party_id = 6,
  show_party_info = TRUE,
  vb = options::opt("vb"),
  rq = NULL
)
}
\arguments{
\item{party_id}{A number or range of numbers. Party number or numbers to retrieve information about. Default is 6
(Rick Gilmore).}

\item{show_party_info}{A logical value. Show the person's name and affiliation in the output.
Default is TRUE.}

\item{vb}{Show verbose messages. (Defaults to \code{FALSE}, overwritable using option 'databraryr.vb' or environment variable 'R_DATABRARYR_VB')}

\item{rq}{An \code{httr2} request object. If not provided, a new request is
generated via \code{make_default_request()}.}
}
\value{
An list with the avatar (image) file and a name_affil string.
}
\description{
Returns the Avatar(s) (images) for Authorized User(s).
}
\examples{
\donttest{
\dontrun{
download_party_avatar() # Show Rick Gilmore's (party 6) avatar.

# Download avatars from Databrary's founders (without name/affiliations)
download_party_avatar(5:7, show_party_info = FALSE)

# Download NYU logo
download_party_avatar(party = 8)
}
}
}
