% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_USGS_samples.R
\name{check_param}
\alias{check_param}
\title{Check values from codeservice}
\usage{
check_param(service = "characteristicgroup", ...)
}
\arguments{
\item{service}{Options are: "characteristicgroup", "states", "counties",
"countries", "sitetype", "samplemedia", "characteristics", "observedproperty"}

\item{...}{Optional additional query arguments. Only "characteristics" and
"observedproperty" have additional parameters options.}
}
\value{
List, structure depends on service.
}
\description{
Call a service to check on values from:
\url{https://api.waterdata.usgs.gov/samples-data/codeservice/docs}.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
groups <- check_param("characteristicgroup")
states <- check_param("states")
countries <- check_param("countries")
counties <- check_param("counties")
sitetypes <- check_param("sitetype")
samplemedia <- check_param("samplemedia")
characteristics <- check_param("characteristics",
                               group = "Biological")
observedProperties <- check_param("observedproperty",
                                  text = "phosphorus")

}
\dontshow{\}) # examplesIf}
}
