% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeSet.R
\name{setAsNumericMatrix}
\alias{setAsNumericMatrix}
\title{Numeric matrix preparation for Machine Learning.}
\usage{
setAsNumericMatrix(dataSet, intercept = FALSE, allCols = FALSE,
  sparse = FALSE)
}
\arguments{
\item{dataSet}{data.table}

\item{intercept}{Should a constant column be added? (logical, default to FALSE)}

\item{allCols}{For each factor, should we create all possible
dummies, or should we drop a reference dummy? (logical, default to FALSE)}

\item{sparse}{Should the resulting matrix be of a (sparse) Matrix
class? (logical, default to FALSE)}
}
\description{
Prepare a numeric matrix from a data.table. This matrix is suitable for
machine learning purposes, since factors are binarized. It may be sparsed,
include an intercept, and drop a reference column for each factor if
required (when using \code{lm()}, for instance)
}
