% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datesManipulations.R
\name{diffDates}
\alias{diffDates}
\title{Date difference}
\usage{
diffDates(dataSet, analysisDate = NULL, units = "years",
  name_separator = ".")
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{analysisDate}{Static date (Date or POSIXct, optional)}

\item{units}{unit of difference between too dates (string, default to 'years')}

\item{name_separator}{Separator to put between words in new column names (default to '.')}
}
\value{
dataSet (as a \code{\link{data.table}}) with more columns. 
A numeric column has been added for every couple of Dates. The result is in years.
}
\description{
Perform the differences between all dates of the dataSet set and optionally with a static date.
}
\details{
\code{units} is the same as \code{\link{difftime}} unites, but with years as a unit.
}
\examples{
# First build a useful dataSet set
require(data.table)
dataSet <- data.table(ID = 1:100, 
                  date1 = seq(from = as.Date("2010-01-01"), 
                              to = as.Date("2015-01-01"), 
                              length.out = 100), 
                  date2 = seq(from = as.Date("1910-01-01"), 
                              to = as.Date("2000-01-01"), 
                              length.out = 100)
                  )

# Now let's compute
dataSet <- diffDates(dataSet, analysisDate = as.Date("2016-11-14"))
}
