% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardVisual.R
\name{standardVisual}
\alias{standardVisual}
\title{Produce distribution plots using ggplot from ggplot2.}
\usage{
standardVisual(v, vnam, doEval = TRUE)
}
\arguments{
\item{v}{The variable (vector) to be plotted.}

\item{vnam}{The name of the variable which will appear as the title of the plot.}

\item{doEval}{If TRUE, the plot itself is returned. Otherwise, the function returns
a character string containing standalone R code for producing the plot.}
}
\description{
Plot the distribution of a variable, depending on its data class, by use of ggplot2. 
Note that \code{standardVisual} is a \code{\link{visualFunction}}, compatible with the 
\code{\link{visualize}} and \code{\link{makeDataReport}} functions.
}
\details{
For character, factor, logical and (haven_)labelled variables, a barplot is produced. For numeric,
integer or Date variables, \code{standardVisual} produces a histogram instead. Note that for
integer and numeric variables, all non-finite (i.e. \code{NA}, \code{NaN}, \code{Inf}) values are
removed prior to plotting. For character, Date, factor, (haven_)labelled and logical variables, 
only \code{NA} values are removed.
}
\examples{
\dontrun{
#Save a variable
myVar <- c(1:10) 

#Plot a variable
standardVisual(myVar, "MyVar")

#Produce code for plotting a variable
standardVisual(myVar, "MyVar", doEval = FALSE)
}
}
\seealso{
\code{\link{visualize}}, \code{\link{basicVisual}}
}
