% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refCat.R
\name{refCat}
\alias{refCat}
\title{summaryFunction that finds reference level for factor variables}
\usage{
refCat(v, ...)
}
\arguments{
\item{v}{A variable (vector) of type factor.}

\item{...}{Not in use.}
}
\value{
An object of class \code{summaryResult} with the following entries: \code{$feature} 
("Reference level"), \code{$result} (the reference level of \code{v}), and \code{$value}
(identical to result).
}
\description{
A \code{summaryFunction}, intended to be called from 
\code{\link{summarize}}, which returns the reference level of a factor variable, 
i.e. the first category as returned by \code{levels(v)}. This level will serve
as the reference category and get absorbed into the intercept for most standard 
model fitting procedures and therefore, it may be convenient to know.
}
\examples{
refCat(factor(letters))

}
\seealso{
\code{\link{summaryFunction}}, \code{\link{summarize}}, \code{\link{summaryResult}},
\code{\link{allSummaryFunctions}}
}
