% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isSingular.R, R/isEmpty.R
\name{isSingular}
\alias{isSingular}
\alias{isEmpty}
\title{Check if a variable only contains a single value}
\usage{
isSingular(v)

isEmpty(v)
}
\arguments{
\item{v}{A variable (vector) to check. All variable types are allowed.}
}
\value{
A \code{\link{checkResult}} with three entires: 
\code{$problem} (a logical indicating whether \code{v} contains only one value), 
\code{$message} (if a problem was found, a message describing which single 
value the variable takes and how many missing observations it contains, otherwise 
""), and \code{$problemValues} (always \code{NULL}).
}
\description{
A \code{\link{checkFunction}} that checks if \code{v} only 
contains a single unique value, aside from missing values. This
function is intended for use as a precheck in \code{\link{makeDataReport}}.
}
\examples{
singularVar <- c(rep("a", 10), NA, NA)
notSingularVar <- c("a", "a", "b", "c", "d", "e", "f", NA, NA)

isSingular(singularVar)
isSingular(notSingularVar)

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}}, 
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
