% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.rename.pop.r
\name{gl.rename.pop}
\alias{gl.rename.pop}
\title{Renames a population in a genlight object}
\usage{
gl.rename.pop(x, old = NULL, new = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing SNP genotypes [required].}

\item{old}{Name of population to be changed [required].}

\item{new}{New name for the population [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object with the new population name.
}
\description{
Individuals are assigned to populations based on the specimen metadata data
file (csv) used with gl.read.dart().

This script renames a nominated population.

The script returns a genlight object with the new population name.
}
\examples{
   gl <- gl.rename.pop(testset.gl, old='EmsubRopeMata', new='Outgroup')
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
