% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.fst.pop.r
\name{gl.fst.pop}
\alias{gl.fst.pop}
\title{Calculates a pairwise Fst values for populations in a genlight object}
\usage{
gl.fst.pop(x, nboots = 100, percent = 95, nclusters = 1, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight containing the SNP genotypes [required].}

\item{nboots}{Number of bootstraps to perform across loci to generate
confidence intervals and p-values [default 100].}

\item{percent}{Percentile to calculate the confidence interval around
[default 95].}

\item{nclusters}{Number of processor threads or cores to use during
calculations [default 1].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A matrix of distances between populations (class dist), if nboots =1,
otherwise a list with Fsts (in a matrix), Pvalues (a matrix of pvalues),
Bootstraps results (data frame of all runs). Hint: Use
\code{as.matrix(as.dist(fsts))} if you want to have a squared matrix with
symmetric entries returned, instead of a dist object.
}
\description{
This script calculates pairwise Fst values based on the implementation in the
StAMPP package (?stamppFst). It allows to run bootstrap to estimate
probability of Fst values to be different from zero. For detailed information
please check the help pages (?stamppFst).
}
\examples{
test <- gl.filter.callrate(platypus.gl,threshold = 1)
test <- gl.filter.monomorphs(test)
out <- gl.fst.pop(test, nboots=1)
}
\author{
Bernd Gruber (bugs? Post to
\url{https://groups.google.com/d/forum/dartr})
}
