% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.rdepth.r
\name{gl.filter.rdepth}
\alias{gl.filter.rdepth}
\title{Filter loci based on counts of sequence tags scored at a locus (read depth)}
\usage{
gl.filter.rdepth(x, lower = 5, upper = 50, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP or tag presence/absence data [required]}

\item{lower}{-- lower threshold value below which loci will be removed [default 5]}

\item{upper}{-- upper threshold value above which loci will be removed [default 50]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2, unless specified using gl.set.verbosity]}
}
\value{
Returns a genlight object retaining loci with a Read Depth in the range specified by the lower and upper threshold.
}
\description{
SNP datasets generated by DArT report AvgCountRef and AvgCountSnp as counts of sequence tags for the reference and alternate alleles respectively.
These can be used to backcalculate Read Depth. Fragment presence/absence datasets as provided by DArT (SilicoDArT) provide Average Read Depth and 
Standard Deviation of Read Depth as stanard columns in their report.
}
\details{
Filtering on Read Depth using the companion script gl.filter.rdepth can be on the basis of loci with exceptionally low counts, 
or loci with exceptionally high counts.
}
\examples{
# SNP data
  gl.report.rdepth(testset.gl)
  result <- gl.filter.rdepth(testset.gl, lower=8, upper=50, verbose=3)
# Tag P/A data
  result <- gl.filter.rdepth(testset.gs, lower=8, upper=50)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
