% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.callrate.r
\name{gl.filter.callrate}
\alias{gl.filter.callrate}
\title{Filter loci or specimens in a genlight \{adegenet\} object based on call rate}
\usage{
gl.filter.callrate(gl, method = "loc", threshold = 0.95)
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data, or the genind object containing the SilocoDArT data [required]}

\item{method}{-- "loc" to specify that loci are to be filtered, "ind" to specify that specimens are to be filtered [default "loc"]}

\item{threshold}{-- threshold value below which loci will be removed [default 0.95]}
}
\value{
The reduced genlight or genind object, plus a summary
}
\description{
SNP datasets generated by DArT have missing values primarily arising from failure to call a SNP because of a mutation
at one or both of the the restriction enzyme recognition sites. This script filters out loci (or specimens) for which the call rate is
lower than a specified value. The script will also filter out loci (or specimens) in SilicoDArT (presence/absence) datasets where the call rate
is lower than the specified value. In this case, the data are missing owing to low coverage.
}
\examples{
result <- gl.filter.callrate(testset.gl, method="ind", threshold=0.8)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
