% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.fixed.diff.r
\name{gl.fixed.diff}
\alias{gl.fixed.diff}
\title{Generate a matrix of fixed differences from a genelight or genind object \{adegenet\}}
\usage{
gl.fixed.diff(gl, t = 0, probar = FALSE)
}
\arguments{
\item{gl}{-- name of the genlight object containing SNP genotypes or a genind object containing presence/absence data [required]}

\item{t}{-- threshold value for tollerance in when a difference is regarded as fixed}

\item{probar}{-- switch to output progress bar [default is false]}
}
\value{
Matrix of fixed differences
}
\description{
This script takes SNP data grouped into populations in a genlight object (DArTSeq)
or presence absence data (SilicoDArT) grouped into populations in a genind object
and generates a matrix of fixed differences between populations taken pairwise
}
\details{
A fixed difference at a locus occurs when two populations share no alleles. The challenge with this approach
is that when sample sizes are finite, fixed differences will occur through sampling error, compounded when
many loci are examined. Simulations suggest that sample sizes of n1=5 and n2=5 is adequate to reduce the
probability of [experiment-wide] type 1 error to negligible levels [ploidy=2]. A warning is issued if comparison
between two populations involves sample sizes less than 5, taking into account allele drop-out.

Tollerance in the definition of a fixed difference is provided by the t parameter. For example, t=0.05 means
that SNP allele frequencies of 95,5 and 5,95 percent will be regarded as fixed.
}
\examples{
#only used the first 20 individuals due to runtime reasons 
mat <- gl.fixed.diff(testset.gl[1:20,], t=0.05)
mat
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
\seealso{
\code{\link{is.fixed}}
}

