% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caret.R
\name{darchModelInfo}
\alias{darchModelInfo}
\title{Creates a custom caret model for \code{darch}.}
\usage{
darchModelInfo(params = NULL, grid = NULL)
}
\arguments{
\item{params}{\code{\link{data.frame}} of parameters or \code{NULL} to use a
simple default (bp.learnRate).}

\item{grid}{Function which procuces a \code{\link{data.frame}} containing a
grid of parameter combinations or \code{NULL} to use a simple default.}
}
\value{
A valid \code{caret}  model which can be passed to
  \code{\link[caret]{train}}.
}
\description{
This function creates a \code{caret} model description to enable training
\code{DArch} instances with the \code{\link[caret]{train}} function. See the
documentation on custom caret models for further information and examples on
how to create valid \code{params} and \code{grid} values.
}
\examples{
\dontrun{
data(iris)
tc <- trainControl(method = "boot", number = 5, allowParallel = F,
  verboseIter = T)

parameters <- data.frame(parameter = c("layers", "bp.learnRate", "darch.unitFunction"),
  class = c("character", "numeric", "character"),
  label = c("Network structure", "Learning rate", "unitFunction"))

grid <- function(x, y, len = NULL, search = "grid")
{
  df <- expand.grid(layers = c("c(0,20,0)","c(0,10,10,0)","c(0,10,5,5,0)"),
   bp.learnRate = c(1,2,5,10))
  
  df[["darch.unitFunction"]] <- rep(c("c(tanhUnit, softmaxUnit)",
   "c(tanhUnit, tanhUnit, softmaxUnit)",
   "c(tanhUnit, tanhUnit, tanhUnit, softmaxUnit)"), 4)
  
  df
}

caretModel <- train(Species ~ ., data = iris, tuneLength = 12, trControl = tc,
  method = darchModelInfo(parameters, grid), preProc = c("center", "scale"),
  darch.numEpochs = 15, darch.batchSize = 6, testing = T, ...)
}
}
\seealso{
\href{https://topepo.github.io/caret/custom_models.html}{Caret custom models}
}

