% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tables.R
\name{get_tables}
\alias{get_tables}
\title{Get a list of stables in the data bank}
\usage{
get_tables(
  subjects = NULL,
  pastdays = NA_integer_,
  include_inactive = FALSE,
  language = c("en", "da")
)
}
\arguments{
\item{subjects}{Provide specific subject id's to get subtopics. E.g. \code{subjects = c("02", "2419")}. Can be retrieved with \code{get_subjects()}}

\item{pastdays}{Return only tables which have been updated within this number of days}

\item{include_inactive}{Whether to return tables that are no longer updated}

\item{language}{Language for the return object. Default = \code{"en"}}
}
\value{
A data frame
}
\description{
Get a list of stables in the data bank
}
\examples{
# Get all tables
all_tables <- get_tables()

# Or get tables for specific subjects
some_tables <- get_tables(subjects = c("02", "2419"))

# Get all tables updated within the past 3 days
tables_past3days <- get_tables(pastdays = 3)
}
