% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get data for a particular table and variable selection}
\usage{
get_data(table_id, variables, language = c("en", "da"))
}
\arguments{
\item{table_id}{Table identifier, e.g. "folk1a"}

\item{variables}{A list with variable code-values pairs. Each code-values pair should be a named list with names "code" and "values".
If all values for a variable are desired, define \code{values = NA} for that variable code.}

\item{language}{Language for the return object. Default = \code{"en"}}
}
\value{
A data frame
}
\description{
Get data for a particular table and variable selection
}
\examples{
# Get data from table "folk1c" for selected values of variables "ieland" and "køn"
# and all time periods available.

# The "ieland" variable is filtered for Denmark (id = 5000) and Bulgaria (id = 5128)
# and the "køn" variable id filtered for Men (id = 1) and Women (id = 2).
# The "tid" variable is unfiltered, i.e. selects all available time periods
# See get_table_metadata(table_id = "folk1c", variables_only = TRUE) for variable codes and values.

variables <- list(list(code = "ieland", values = c(5100, 5128)),
                  list(code = "køn", values = c(1,2)),
                  list(code = "tid", values = NA))

data <- get_data("folk1c", variables)
}
