% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evsi.R
\name{plot.evsi}
\alias{plot.evsi}
\title{Plot of Expected Value of Sample Information (EVSI)}
\usage{
\method{plot}{evsi}(
  x,
  txtsize = 12,
  currency = "$",
  effect_units = "QALY",
  n_y_ticks = 8,
  n_x_ticks = 20,
  xbreaks = NULL,
  ybreaks = NULL,
  xlim = c(0, NA),
  ylim = NULL,
  col = c("full", "bw"),
  ...
)
}
\arguments{
\item{x}{object of class \code{evsi}, produced by function
\code{\link{calc_evsi}}}

\item{txtsize}{base text size}

\item{currency}{string with currency used in the cost-effectiveness analysis (CEA).
Default: $, but it could be any currency symbol or word (e.g., £, €, peso)}

\item{effect_units}{units of effectiveness. Default: QALY}

\item{n_y_ticks}{number of axis ticks}

\item{n_x_ticks}{number of axis ticks}

\item{xbreaks}{vector of axis breaks.
will override \code{n_x_ticks} and/or \code{n_y_ticks} if provided.}

\item{ybreaks}{vector of axis breaks.
will override \code{n_x_ticks} and/or \code{n_y_ticks} if provided.}

\item{xlim}{vector of axis limits, or NULL, which sets limits automatically}

\item{ylim}{vector of axis limits, or NULL, which sets limits automatically}

\item{col}{either none, full color, or black and white}

\item{...}{further arguments to plot.
This is not used by \code{dampack} but required for generic consistency.}
}
\value{
A \code{ggplot2} plot with the EVSI
}
\description{
Plots the \code{evsi} object created by \code{\link{calc_evsi}}.
EVSI is either plotted as a function of additional sample size
for each willingness-to-pay threshold provided, or
as a function of each willingness-to-pay
threshold, depending upon the usage of \code{\link{calc_evsi}}
used to create the \code{evsi} object.
}
\seealso{
\code{\link{calc_evsi}}
}
\keyword{expected}
\keyword{information}
\keyword{of}
\keyword{sample}
\keyword{value}
