% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_quantiles}
\alias{calc_quantiles}
\title{Calculate Quantiles}
\usage{
calc_quantiles(
  pdf_u = NULL,
  pdf_l = NULL,
  t_vec = NULL,
  rts_u = NULL,
  rts_l = NULL,
  one_cond,
  probs = NULL,
  b_coding
)
}
\arguments{
\item{pdf_u, pdf_l}{either NULL or density vectors}

\item{t_vec}{the time space (required for the pdfs)}

\item{rts_u, rts_l}{either NULL or RT vectors}

\item{one_cond}{character label}

\item{probs}{numeric vector with values between 0 and 1 for the probability
levels. Default is \code{\link[=drift_dm_default_probs]{drift_dm_default_probs()}}.}

\item{b_coding}{used for accessing the upper/lower boundary labels,
determines the corresponding columns of the returned data.frame
(e.g., Quant_\code{corr}).}
}
\value{
a data.frame with "Source", "Cond", "Prob"s, "Quant_<u_label>",
"Quant_<l_label>" of type
c("quantiles", "sum_dist", "stats_dm", "data.frame")
}
\description{
Function that calls the underlying quantile calculation functions
\link{calc_quantiles_obs} and \link{calc_quantiles_pred}. Does
input checks and the data wrangling
}
\details{
if pdf_u and pdf_l are not NULL, returns quantiles for the densities

if rts_u and rts_l are not NULL, returns quantiles for the response times

if all are not NULL, returns both.
}
\seealso{
\code{\link[=new_stats_dm]{new_stats_dm()}}
}
\keyword{internal}
