% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/parClass.R
\name{parvec}
\alias{[.parvec}
\alias{as.parvec}
\alias{as.parvec.numeric}
\alias{c.parvec}
\alias{parvec}
\title{Parameter vector}
\usage{
parvec(..., deriv = NULL)

as.parvec(x, ...)

\method{as.parvec}{numeric}(x, names = NULL, deriv = NULL, ...)

\method{[}{parvec}(x, ..., drop = FALSE)

\method{c}{parvec}(...)
}
\arguments{
\item{...}{objects to be concatenated}

\item{deriv}{matrix with rownames (according to names of \code{...}) and colnames
according to the names of the parameter by which the parameter vector was generated.}

\item{x}{numeric or named numeric, the parameter values}

\item{names}{optional character vector, the parameter names. Otherwise, names
are taken from \code{x}.}

\item{drop}{logical, drop empty columns in Jacobian after subsetting. 
ATTENTION: Be careful with this option. The default behavior is to keep
the columns in the Jacobian. This can lead to unintended results when
subsetting the parvec and using it e.g. in another parameter
transformation.}
}
\value{
An object of class \code{parvec}, i.e. a named numeric vector with attribute "deriv".
}
\description{
A parameter vector is a named numeric vector (the parameter values)
together with a "deriv" attribute 
(the Jacobian of a parameter transformation by which the parameter vector was generated).

Dispatch as.parvec.

Parameter vector
}
\examples{
# Generate a parameter vector
v <- parvec(a = 2, b = 3)
print(v)
print(getDerivs(v))

# Parameter vector from a named numeric
M <- matrix(c(1, 1, 0, 1), 
	    nrow = 2, ncol = 2, 
	    dimnames = list(c("a", "b"), c("A", "B"))
    )
v <- as.parvec(x = c(a = 2, b = 3), deriv = M)
print(v)
print(getDerivs(v))

# Subsetting of parameter vectors
# Case 1: Dependencies in the Jacobian are maintained
w <- v[1]
print(w)
print(getDerivs(w))

# Case 2: Dependencies are dropped
w <- v[1, drop = TRUE]
print(w)
print(getDerivs(w))

# Concatenating parameter vectors
w <- parvec(c = 4, d = 5)
print(c(v, w))
print(getDerivs(c(v, w)))
}

