% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/toolsMarcus.R
\name{constraintExp2}
\alias{constraintExp2}
\title{Compute a differentiable box prior}
\usage{
constraintExp2(p, mu, sigma = 1, k = 0.05, fixed = NULL)
}
\arguments{
\item{p}{Named numeric, the parameter value}

\item{mu}{Named numeric, the prior values, means of boxes}

\item{sigma}{Named numeric, half box width}

\item{k}{Named numeric, shape of box; if 0 a quadratic prior is obtained, the higher k the more box shape, gradient at border of the box (-sigma, sigma) is equal to sigma*k}

\item{fixed}{Named numeric with fixed parameter values (contribute to the prior value but not to gradient and Hessian)}
}
\value{
list with entries: value (numeric, the weighted residual sum of squares),
gradient (numeric, gradient) and
hessian (matrix of type numeric).
}
\description{
Compute a differentiable box prior
}

