% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmklm.R
\name{tmklm}
\alias{tmklm}
\title{Two-Mode KL-Means Heuristic}
\usage{
tmklm(A, RC, CC, TLIMIT)
}
\arguments{
\item{A}{An \eqn{RO x CO} two-mode network matrix.}

\item{RC}{The number of clusters for row objects (\eqn{1 < RC < RO}).}

\item{CC}{The number of clusters for column objects (\eqn{1 < CC < CO}).}

\item{TLIMIT}{A desired time limit.}
}
\value{
The function returns the following:
\itemize{
\item \code{vaf} - the variance-accounted-for;
\item \code{RP} - an \eqn{RO}-dimensional vector of row cluser assignements;
\item \code{RC} - an \eqn{RC}-dimensional vector of column cluser assignements;
\item \code{restarts} - the number of restarts within the time limit.
}
}
\description{
This function runs two-mode K-means for an \eqn{RO x CO} network matrix.
}
\examples{
# Load the Turning Point Project network (Brusco & Doreian, 2015) data.
data("nyt")

# Run two-mode K-means procedure.
res <- tmklm(nyt,RC = 9,CC = 5,TLIMIT = 1)

# See the results.
res
}
\references{
Brusco, M. J., Doreian, P., & Steinley, D. (2019). Deterministic blockmodeling of signed and two-mode networks: a tutorial with psychological examples. \emph{British Journal of Mathematical and Statistical Psychology}.

Baier, D., Gaul, W., & Schader, M. (1997). Two-mode overlapping clustering with applications in simultaneous benefit segmentation and market structuring. In R. Klar & O. Opitz (Eds), \emph{Classification and knowledge organization} (pp. 557-566), Heidelberg: Springer.

Brusco, M., & Doreian, P. (2015). A real-coded genetic algorithm for two-mode KL-means partitioning with application to homogeneity blockmodeling. \emph{Social Networks}, 41, 26-35. http://dx.doi.org/10.1016/j.socnet.2014.11.007
}
\author{
Michael Brusco
}
