% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{pkg_utils}
\alias{pkg_utils}
\alias{pkg_create_cwb_dirs}
\alias{pkg_add_corpus}
\alias{pkg_add_configure_scripts}
\alias{pkg_add_description}
\alias{pkg_add_creativecommons_license}
\alias{pkg_add_gitattributes_file}
\title{Create and manage packages with corpus data.}
\usage{
pkg_create_cwb_dirs(pkg = ".", verbose = TRUE)

pkg_add_corpus(
  pkg = ".",
  corpus,
  registry = Sys.getenv("CORPUS_REGISTRY"),
  verbose = TRUE
)

pkg_add_configure_scripts(pkg = ".")

pkg_add_description(
  pkg = ".",
  package = NULL,
  version = "0.0.1",
  date = Sys.Date(),
  author,
  maintainer = NULL,
  description = "",
  license = "",
  verbose = TRUE
)

pkg_add_creativecommons_license(
  pkg = ".",
  license = "CC-BY-NC-SA",
  file = system.file(package = "cwbtools", "txt", "licenses", "CC_BY-NC-SA_3.0.txt")
)

pkg_add_gitattributes_file(pkg = ".")
}
\arguments{
\item{pkg}{Path to directory of data package or package name.}

\item{verbose}{A \code{logical} value, whether to be verbose.}

\item{corpus}{Name of the CWB corpus to insert into the package.}

\item{registry}{Registry directory.}

\item{package}{The package name (\code{character}), may not include special
chars, and no underscores ('_').}

\item{version}{The version number of the corpus (defaults to "0.0.1")}

\item{date}{The date of creation, defaults to \code{Sys.Date()}.}

\item{author}{The author of the package, either character vector or object of class \code{person}.}

\item{maintainer}{Maintainer, R package style, either \code{character} vector or \code{person}.}

\item{description}{description of the data package.}

\item{license}{The license.}

\item{file}{Path to file with fulltext of Creative Commons license.}
}
\description{
Putting CWB indexed corpora into R data packages is a convenient way to ship
and share corpora, and to keep documentation and supplementary functionality
with the data.
}
\details{
\code{pkg_creage_cwb_dirs} will create the standard directory
  structure for storing registry files and indexed corpora within a package
  (\code{./inst/extdata/cwb/registry} and
  \code{./inst/extdata/cwb/indexed_corpora}, respectively).

\code{pkg_add_corpus} will add the corpus described in registry directory to
the package defined by \code{pkg}.

\code{add_configure_script} will add standardized and tested
  configure scripts \code{configure} for Linux and macOS, and
  \code{configure.win} for Windows to the top level directory of the data
  package, and file \code{setpaths.R} to \code{tools} subdirectory. The
  configuration mechanism ensures that the data directory is specified
  correctly in the registry files during the installation of the data
  package.

\code{pkg_add_description} will add a description file to the package.

\code{pkg_add_creativecommons_license} will license information to
  the DESCRIPTION file, and move file LICENSE to top level directory of the
  package.

\code{pkg_add_gitattributes_file} will add a file '.gitattributes'
  to the package. The file defines types of files that will be tracked by Git
  LFS, i.e. they will not be under conventional version control. This is
  suitable for large binary files, which is the scenario applicable for
  indexed corpus data.
}
\examples{
pkgdir <- normalizePath(tempdir(), winslash = "/")
pkg_create_cwb_dirs(pkg = pkgdir)
pkg_add_description(
  pkg = pkgdir,
  package = "reuters",
  author = "cwbtools",
  description = "Reuters data package"
 )
pkg_add_corpus(
  pkg = pkgdir, corpus = "REUTERS",
  registry = system.file(package = "RcppCWB", "extdata", "cwb", "registry")
)
pkg_add_gitattributes_file(pkg = pkgdir)
pkg_add_configure_scripts(pkg = pkgdir)
pkg_add_creativecommons_license(pkg = pkgdir)
}
\references{
Blätte, Andreas (2018). "Using Data Packages to Ship Annotated
  Corpora of Parliamentary Protocols: The GermaParl R Package",
  \emph{ParlaCLARIN 2018 Workshop Proceedings}, available online
  \href{http://lrec-conf.org/workshops/lrec2018/W2/pdf/15_W2.pdf}{here}.
}
\seealso{
The \code{\link[usethis]{use_description}} function in the usethis-package will also create a DESCRIPTION file.
}
