% Generated by roxygen2 (4.0.1): do not edit by hand
\name{weights_graph}
\alias{weights_graph}
\title{Weights Graph Adjacency Matrix}
\usage{
weights_graph(w, n)
}
\arguments{
\item{w}{Weights vector}

\item{n}{Number of points being clustered}
}
\description{
Constructs the adjacency matrix of the weights graph. This is useful to determine the connectivity of the weights graph.
}
\examples{
## Clusterpaths for Mammal Dentition
data(mammals)
X <- as.matrix(mammals[,-1])
X <- t(scale(X,center=TRUE,scale=FALSE))
n <- ncol(X)

## Pick some weights and a sequence of regularization parameters.
k <- 5
phi <- 0.5
w <- kernel_weights(X,phi)
w <- knn_weights(w,k,n)

A <- weights_graph(w,n)
find_clusters(A)

## Visualize Cluster Assignment
G <- graph.adjacency(A, mode = 'upper')
plot(G,vertex.label=as.character(mammals[,1]),vertex.label.cex=0.65,vertex.label.font=2)
}

