library(cvms)
context("update_hyperparameters()")

test_that("hparams are correctly updated with update_hyperparameters()", {

  ## Testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- update_hyperparameters(k=3, "u" = 4, hyperparameters = list("o" = 1, "u" = 5), .required = "o")
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(k = 3, u = 5, o = 1))
  # Testing names
  expect_equal(
    names(output_19148),
    c("k", "u", "o"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'     ####

  ## Testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(update_hyperparameters(k=3, "u" = 4, hyperparameters = list("u" = 5), .required = "o"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("these hyperparameters are required but were not present: o"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'     ####

  ## Testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- update_hyperparameters(k=3, "u" = 4, hyperparameters = list("o" = 1, "u" = 5), .required = NULL)
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(k = 3, u = 5, o = 1))
  # Testing names
  expect_equal(
    names(output_19148),
    c("k", "u", "o"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'     ####

  ## Testing 'update_hyperparameters(k=3, u = 4, hyperpara...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- update_hyperparameters(k=3, u = 4, hyperparameters = list("o" = 1, "u" = 5), .required = "o")
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(k = 3, u = 5, o = 1))
  # Testing names
  expect_equal(
    names(output_19148),
    c("k", "u", "o"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'update_hyperparameters(k=3, u = 4, hyperpara...'     ####


  ## Testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(update_hyperparameters(k=3, "u" = 4, hyperparameters = list("o" = 1, "u" = 5), .required = list("o")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'required': Must be of type 'character' (or 'NULL'), not 'list'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'     ####

  ## Testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14820 <- xpectr::capture_side_effects(update_hyperparameters(k = 3, "u" = 4, hyperparameters = c("o" = 1, "u" = 5), .required = "o"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14820[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_list(hyperparameters): Must be of type 'list', not 'double'\n * checkmate::check_data_frame(hyperparameters): Must be of type 'data.frame', not 'double'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14820[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'update_hyperparameters(k=3, "u" = 4, hyperpa...'     ####

  ## Testing 'update_hyperparameters(3, 4, hyperparameters...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(update_hyperparameters(3, 4, hyperparameters = list("o" = 1, "u" = 5), .required = "o"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("all arguments in '...' must be named."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'update_hyperparameters(3, 4, hyperparameters...'     ####

})
