% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_hyperparameters.R
\name{update_hyperparameters}
\alias{update_hyperparameters}
\title{Check and update hyperparameters}
\usage{
update_hyperparameters(..., hyperparameters, .required = NULL)
}
\arguments{
\item{...}{Default values for missing hyperparameters.

 E.g.:

 \code{kernel = "linear", cost = 10}}

\item{hyperparameters}{\code{list} of hyperparameters as supplied to
\code{\link[cvms:cross_validate_fn]{cross_validate_fn()}}.
Can also be a single-row \code{data.frame}.}

\item{.required}{Names of required hyperparameters. If any of these
are not present in the hyperparameters, an \code{error} is thrown.}
}
\value{
A \code{named list} with the updated hyperparameters.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 \enumerate{
   \item Checks if the required hyperparameters are present and
         throws an error when it is not the case.
   \item Inserts the missing hyperparameters with the supplied
         default values.
 }

 For managing hyperparameters in custom model functions for
 \code{\link[cvms:cross_validate_fn]{cross_validate_fn()}} or
 \code{\link[cvms:validate_fn]{validate_fn()}}.
}
\examples{
\donttest{
# Attach packages
library(cvms)

# Create a list of hyperparameters
hparams <- list(
  "kernel" = "radial",
  "scale" = TRUE
)

# Update hyperparameters with defaults
# Only 'cost' is changed as it's missing
update_hyperparameters(
  cost = 10,
  kernel = "linear",
  "scale" = FALSE,
  hyperparameters = hparams
)

# 'cost' is required
# throws error
xpectr::capture_side_effects(
  update_hyperparameters(
    kernel = "linear",
    "scale" = FALSE,
    hyperparameters = hparams,
    .required = "cost"
  )
)

}
}
\seealso{
Other example functions: 
\code{\link{model_functions}()},
\code{\link{predict_functions}()},
\code{\link{preprocess_functions}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{example functions}
