% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{compatible.formula.terms}
\alias{compatible.formula.terms}
\title{Compatible formula terms}
\format{A data frame with 162,660 rows and 5 variables:
\describe{
  \item{left}{term, fixed effect or interaction, with fixed effects separated by "\code{*}"}
  \item{right}{term, fixed effect or interaction, with fixed effects separated by "\code{*}"}
  \item{max_interaction_size}{maximum interaction size in the two terms, up to \code{3}}
  \item{num_effects}{number of unique fixed effects in the two terms, up to \code{5}}
  \item{min_num_fixed_effects}{minimum number of fixed effects required to use a formula with the two terms,
  i.e. the index in the alphabet of the last of the alphabetically ordered effects (letters) in the two terms,
  so \code{4} if \code{left == "A"} and \code{right == "D"} }
}}
\description{
162,660 pairs of compatible terms for building model formulas with up to 15 fixed effects.
}
\details{
A term is either a fixed effect or an interaction between fixed effects (up to three-way), where
the effects are separated by the "\code{*}" operator.

Two terms are compatible if they are not redundant,
meaning that both add a fixed effect to the formula. E.g. as the interaction
\code{"x1 * x2 * x3"} expands to \code{"x1 + x2 + x3 + x1 * x2 + x1 * x3 + x2 * x3 + x1 * x2 * x3"},
the higher order interaction makes these "sub terms" redundant. Note: All terms are compatible with \code{NA}.

Effects are represented by the first fifteen capital letters.

Used to generate the model formulas for \code{\link[cvms:combine_predictors]{combine_predictors}}.
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\keyword{data}
